/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.core.zend.debugger.handlers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org2.eclipse.php.debug.core.debugger.IDebugHandler;
import org2.eclipse.php.debug.core.debugger.handlers.IDebugMessageHandler;
import org2.eclipse.php.debug.core.debugger.messages.IDebugMessage;
import org2.eclipse.php.internal.debug.core.zend.debugger.DebugError;
import org2.eclipse.php.internal.debug.core.zend.debugger.messages.ParsingErrorNotification;
import org2.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;

public class ParsingErrorNotificationHandler
implements IDebugMessageHandler {
    private static final Pattern EVALD_CODE_PATTERN = Pattern.compile("(.*)\\((\\d+)\\) : eval\\(\\)'d code");

    @Override
    public void handle(IDebugMessage message, PHPDebugTarget debugTarget) {
        ParsingErrorNotification parseError = (ParsingErrorNotification)message;
        IDebugHandler debugHandler = debugTarget.getRemoteDebugger().getDebugHandler();
        String errorText = parseError.getErrorText();
        int lineNumber = parseError.getLineNumber();
        int errorLevel = parseError.getErrorLevel();
        String fileName = parseError.getFileName();
        Matcher m = EVALD_CODE_PATTERN.matcher(fileName);
        if (m.matches()) {
            fileName = m.group(1);
            lineNumber = Integer.parseInt(m.group(2));
        }
        DebugError debugError = new DebugError(errorLevel, fileName, lineNumber, errorText);
        debugHandler.parsingErrorOccured(debugError);
    }
}

